# Задача флага Нидерландов

#### Постановка задачи

Дан массив с несколькими цветами (красный, белый и синий), нужно упорядочить его таким образом, чтобы все цвета были сгруппированы вместе. Мы будем использовать целые числа `0`, `1` и `2` для представления красного, белого и синего цветов соответственно.

Нужно отсортировать массив на месте без использования дополнительной памяти и стандартной функции сортировки.

#### Алгоритм

1. Создайте три указателя - `low`, `mid` и `high`.
1. Установите `low` и `mid` в начало массива, а `high` в конец массива.
1. Сравните `nums[mid]` со значением `1`.
   - Если `nums[mid]` равен 1, просто увеличьте mid.
   - Если `nums[mid]` равен 0, поменяйте `nums[mid]` и `nums[low]`, а затем увеличьте `mid` и `low` на 1.
   - Если `nums[mid]` равен 2, поменяйте `nums[mid]` и `nums[high]`, а затем уменьшите `high` на 1.
1. Продолжайте шаги 3 до тех пор, пока `mid <= high`.

#### Временная сложность

- O(n)

#### Пространственная сложность

- O(1)

#### Пример

```python
nums = [2, 0, 2, 1, 1, 0]

print(dutch_flag_sort(nums))
# Output: [0, 0, 1, 1, 2, 2]
```

#### Ссылки на реализации алгоритма

- [Java](https://github.com/TheAlgorithms/Java/blob/master/src/main/java/com/thealgorithms/sorts/DutchNationalFlagSort.java)
- [Python](https://github.com/TheAlgorithms/Python/blob/master/sorts/dutch_national_flag_sort.py)
